#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

class Observer{ // interface for shop
    virtual void notify(float price)=0;
};

class ConcreteObserver:public Observer{ // specific shop
private:
    string name;
    float price;
public:
    ConcreteObserver(string name){
        this->name=name;
    }
    void notify(float price){
        this->price=price;
        cout<<name<<": new price ("<<this->price<<") received"<<endl;
    }
};

class Subject{ // generic product
private:
    vector<ConcreteObserver*> shopList;
public:
    void registerObserver(ConcreteObserver* shop){
        shopList.push_back(shop);}
    void unregisterObserver(ConcreteObserver* shop){
        shopList.erase(remove(shopList.begin(),shopList.end(),shop),shopList.end());
        }
    void notifyObserver(float price){
        for(vector<ConcreteObserver*>::const_iterator it=shopList.begin();it!=shopList.end();++it){
            if(*it!=0){
                (*it)->notify(price);
            }
        }
    }
};

class ConcreteSubject:public Subject{ // specific product
public:
    void changePrice(float price){
        notifyObserver(price);
    }
};

int main(){
    // we have several shops that want to be kept up to date about price changes
    ConcreteSubject product;
    ConcreteObserver shop1("Shop1");
    ConcreteObserver shop2("Shop2");
    product.registerObserver(&shop1);
    product.registerObserver(&shop2);
    product.changePrice(25.5);
    product.unregisterObserver(&shop1);
    product.changePrice(26.0);
    return 0;
}
